/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeSchemaModel;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APITypeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(APITypeModel.class);
    protected Class<? extends TypeDefinition> typeDefinitionClass;
    protected MediaType mediaType;
    protected String example;
    protected List<String> enumValues;
    protected APITypeSchemaModel APITypeSchemaModel;
    protected APIPrimitiveTypeModel primitiveTypeModel;
    protected List<APIParameterModel> parts;
    protected APITypeModel innerType;
    protected List<APITypeModel> unionTypes;
    protected String displayName;
    protected String description;

    protected APITypeModel() {
    }

    protected APITypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
        this.typeDefinitionClass = PrimitiveTypeDefinition.class;
        this.primitiveTypeModel = primitiveTypeModel;
    }

    protected MediaType getMediaTypeForStringOrNull(String mediaType) {
        try {
            return StringUtils.isNotBlank((CharSequence)mediaType) ? MediaType.valueOf((String)mediaType) : null;
        }
        catch (Exception e) {
            LOGGER.error("Error getting media type", (Throwable)e);
            return null;
        }
    }

    public Class<? extends TypeDefinition> getTypeDefinitionClass() {
        return this.typeDefinitionClass;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public APITypeSchemaModel getAPITypeSchemaModel() {
        return this.APITypeSchemaModel;
    }

    public APIPrimitiveTypeModel getPrimitiveTypeModel() {
        return this.primitiveTypeModel;
    }

    public List<APIParameterModel> getParts() {
        return this.parts;
    }

    public APITypeModel getInnerType() {
        return this.innerType;
    }

    public List<APITypeModel> getUnionTypes() {
        return this.unionTypes;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

