/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.core.model.domain.Shape;
import amf.plugins.xml.transformer.TypeToXmlSchema;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;
import org.apache.ws.commons.schema.XmlSchema;

public class AMFTypeSchemaSupplier
implements Supplier<String> {
    private final AnyShape shape;
    private final MediaType mediaType;

    AMFTypeSchemaSupplier(AnyShape shape, MediaType mediaType) {
        this.shape = shape;
        this.mediaType = mediaType;
    }

    @Override
    public String get() {
        if (this.mediaType != null && this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return this.buildXmlTypeSchema(this.shape);
        }
        return this.shape.buildJsonSchema();
    }

    private String buildXmlTypeSchema(AnyShape anyShape) {
        XmlSchema xmlSchema = TypeToXmlSchema.transform((String)"root", (Shape)anyShape._internal());
        xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");
        StringWriter schemaWriter = new StringWriter();
        xmlSchema.write((Writer)schemaWriter);
        return schemaWriter.toString();
    }
}

