/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.security.OAS2SecuritySchemes;
import java.util.Arrays;

public class AMFSecuritySchemesNaming {
    private AMFSecuritySchemesNaming() {
    }

    public static boolean isOauth1(String name) {
        return "OAuth 1.0".equalsIgnoreCase(name);
    }

    public static boolean isOauth2(String name) {
        return "OAuth 2.0".equalsIgnoreCase(name) || "OAuth 2.0".equalsIgnoreCase(name);
    }

    public static boolean isPassThrough(String name) {
        return "Pass Through".equalsIgnoreCase(name);
    }

    public static boolean isApiKey(String name) {
        return Arrays.stream(OAS2SecuritySchemes.API_KEY).anyMatch(x -> x.equalsIgnoreCase(name));
    }

    public static boolean isBasicAuth(String name) {
        return "Basic Authentication".equalsIgnoreCase(name) || "Basic Authentication".equalsIgnoreCase(name);
    }

    public static boolean isDigest(String name) {
        return "Digest Authentication".equalsIgnoreCase(name);
    }

    public static boolean isCustom(String name) {
        return name.toLowerCase().startsWith("x-");
    }
}

