/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class OperationNamingUtils {
    private OperationNamingUtils() {
    }

    public static String buildFriendlyCanonicalOperationName(HTTPMethod method, String path) {
        String lowerCaseName = OperationNamingUtils.buildCanonicalOperationName(method, path).toLowerCase().replace('_', ' ');
        return StringUtils.capitalize((String)lowerCaseName);
    }

    public static List<String> getPathResources(String path) {
        return OperationNamingUtils.getPathElements(path, false);
    }

    public static List<String> getPathParameters(String path) {
        return OperationNamingUtils.getPathElements(path, true);
    }

    private static List<String> getPathElements(String path, boolean findParameters) {
        LinkedList<String> elements = new LinkedList<String>();
        String remainingPath = OperationNamingUtils.replaceODataParams(path);
        while (StringUtils.isNotBlank((CharSequence)remainingPath)) {
            String pathSegment;
            int resourceEndIndex = remainingPath.indexOf(47);
            if (resourceEndIndex < 0) {
                resourceEndIndex = remainingPath.length();
            }
            if (StringUtils.isNotBlank((CharSequence)(pathSegment = remainingPath.substring(0, resourceEndIndex))) && OperationNamingUtils.isUriParameter(pathSegment) == findParameters) {
                elements.add(OperationNamingUtils.getCapUnderscoreName(pathSegment));
            }
            if (resourceEndIndex < remainingPath.length()) {
                remainingPath = remainingPath.substring(resourceEndIndex + 1);
                continue;
            }
            remainingPath = remainingPath.substring(resourceEndIndex);
        }
        return elements;
    }

    public static String buildCanonicalOperationName(HTTPMethod method, String path) {
        List<String> resources = OperationNamingUtils.getPathResources(path);
        List<String> parameters = OperationNamingUtils.getPathParameters(path);
        StringBuilder operationNameBuilder = new StringBuilder(method.getActionName());
        if (!resources.isEmpty()) {
            operationNameBuilder.append("_").append(StringUtils.join(resources, (String)"_"));
        }
        if (!parameters.isEmpty()) {
            operationNameBuilder.append("_BY_").append(StringUtils.join(parameters, (String)"_"));
        }
        return operationNameBuilder.toString();
    }

    private static String replaceODataParams(String string) {
        Pattern oDataParameterPattern = Pattern.compile("([^\\s\\(\\)\\{\\}\\=\\,]+)\\=\\'\\{([^\\s\\(\\)\\{\\}\\=\\,]+)\\}\\'");
        Matcher oDataParameterMatcher = oDataParameterPattern.matcher(string);
        return oDataParameterMatcher.replaceAll("$1");
    }

    private static boolean isUriParameter(String pathSegment) {
        return pathSegment.matches("\\{.*\\}");
    }

    private static String getCapUnderscoreName(String name) {
        return OperationNamingUtils.splitCapsWithUnderscores(OperationNamingUtils.getSanitizedOperationName(name)).toUpperCase();
    }

    private static String getSanitizedOperationName(String name) {
        name = name.replaceAll("-", "_");
        if ((name = name.replaceAll("[^a-zA-Z0-9_-]", "")).startsWith("_")) {
            name = name.replaceFirst("_", "");
        }
        return name;
    }

    private static String splitCapsWithUnderscores(String name) {
        return ParserUtils.splitCaps(name, "_");
    }
}

