/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType.NOT_SUPPORTED;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.WARN;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;

import java.util.List;

public class NotSupportedSecuritySchemeRule extends PreValidationRule {

  //R010
  public NotSupportedSecuritySchemeRule() {
    super("The API spec defines a security scheme that is not supported",
          EMPTY,
          WARN);
  }

  @Override
  public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
    return apiModel.getOperationsModel().stream()
        .flatMap(apiOp -> apiOp.getSecuritySchemesModel().stream())
        .filter(securityScheme -> securityScheme.getSecuritySchemeType().equals(NOT_SUPPORTED))
        .map(APISecuritySchemeModel::getName)
        .distinct()
        .map(this::getValidationError)
        .collect(toList());
  }

  private ValidationError getValidationError(String securitySchemeName) {

    final String detail = "Security scheme '" + securitySchemeName + "' type is not supported";
    return new ValidationError(this, detail, DescriptorElementLocation.builder().empty());
  }
}
