/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.AtLeastOneSupportedSecuritySchemeRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.BaseJavaPackageMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorNameMustBeFriendlyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorInputMediaTypeMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorOperationMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorOtputMediaTypeMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorParameterMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorPathMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorRedundantOutputDefinitionRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ExtensionXmlMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.GavArtifactIdMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.GavGroupIdMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.GavVersionMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.NoDefaultInputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.NoDefaultOutputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.NoInputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.NoOutputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.NotSupportedSecuritySchemeRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.OperationMustDeclareResponseBodyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.OperationNameMustBeFriendlyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.PagedOperationsOperationMustDeclareResponseBodyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ParameterNameMustBeFriendlyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.SampleDataMarkerMustBeGETRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.TriggerBindingParameterMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.TriggerPathAndMethodMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.TriggerUriParamsMustBeCompleteRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValueResolverReferenceArgumentsExistsRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValueResolverReferenceArgumentsHaveValidFormatRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValueResolverReferenceExistsRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ModelValidator {
    private final List<ValidationRule> validationRules;

    public ModelValidator() {
        this.validationRules = ModelValidator.getAllRules();
    }

    public ModelValidator(List<ValidationRule> rules) {
        this.validationRules = rules;
    }

    public List<ValidationError> preValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        return this.validationRules.stream().flatMap(x -> x.preValidate(connectorDescriptor, apiModel).stream()).collect(Collectors.toList());
    }

    public List<ValidationError> postValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModel connectorModel) {
        return this.validationRules.stream().flatMap(x -> x.postValidate(connectorDescriptor, apiModel, connectorModel).stream()).collect(Collectors.toList());
    }

    private static List<ValidationRule> getAllRules() {
        LinkedList<ValidationRule> allRules = new LinkedList<ValidationRule>();
        allRules.add(new DescriptorPathMustExistInApiRule());
        allRules.add(new DescriptorOperationMustExistInApiRule());
        allRules.add(new OperationMustDeclareResponseBodyRule());
        allRules.add(new AtLeastOneSupportedSecuritySchemeRule());
        allRules.add(new ExtensionXmlMustBeValidRule());
        allRules.add(new BaseJavaPackageMustBeValidRule());
        allRules.add(new GavGroupIdMustBeValidRule());
        allRules.add(new GavArtifactIdMustBeValidRule());
        allRules.add(new GavVersionMustBeValidRule());
        allRules.add(new NotSupportedSecuritySchemeRule());
        allRules.add(new ConnectorNameMustBeFriendlyRule());
        allRules.add(new OperationNameMustBeFriendlyRule());
        allRules.add(new ParameterNameMustBeFriendlyRule());
        allRules.add(new NoDefaultInputMediaTypeDefinedRule());
        allRules.add(new NoDefaultOutputMediaTypeDefinedRule());
        allRules.add(new DescriptorParameterMustBePresentInApiRule());
        allRules.add(new NoInputMediaTypeDefinedRule());
        allRules.add(new DescriptorInputMediaTypeMustBePresentInApiRule());
        allRules.add(new NoOutputMediaTypeDefinedRule());
        allRules.add(new DescriptorOtputMediaTypeMustBePresentInApiRule());
        allRules.add(new DescriptorRedundantOutputDefinitionRule());
        allRules.add(new PagedOperationsOperationMustDeclareResponseBodyRule());
        allRules.add(new TriggerPathAndMethodMustExistInApiRule());
        allRules.add(new TriggerBindingParameterMustExistInApiRule());
        allRules.add(new TriggerUriParamsMustBeCompleteRule());
        allRules.add(new ValueResolverReferenceExistsRule());
        allRules.add(new ValueResolverReferenceArgumentsExistsRule());
        allRules.add(new ValueResolverReferenceArgumentsHaveValidFormatRule());
        allRules.add(new SampleDataMarkerMustBeGETRule());
        return allRules;
    }
}

