/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NoInputMediaTypeDefinedRule
extends PreValidationRule {
    public NoInputMediaTypeDefinedRule() {
        super("Defining a media type for the operations input type is mandatory", "If an operation defines an input type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getDefaultInputMediaType())) {
            return Collections.emptyList();
        }
        LinkedList<ValidationError> allErrors = new LinkedList<ValidationError>();
        apiModel.getOperationsModel().stream().filter(apiOp -> !apiOp.getInputMetadataModel().isEmpty()).filter(apiOp -> !this.inputMediaTypeDefinedInAPISpec((APIOperationModel)apiOp)).filter(apiOp -> !this.inputMediaTypeDefinedInDescriptor((APIOperationModel)apiOp, connectorDescriptor)).map(apiOp -> this.getValidationErrorForApiSpec((APIOperationModel)apiOp, connectorDescriptor)).forEach(allErrors::add);
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            endpoint.getOperations().stream().filter(opDesc -> StringUtils.isNotBlank((CharSequence)opDesc.getInputTypeSchema())).filter(opDesc -> StringUtils.isBlank((CharSequence)opDesc.getInputMediaType())).filter(opDesc -> !this.inputMediaTypeDefinedInAPISpec(apiModel, endpoint.getPath(), opDesc.getMethod())).map(this::getValidationErrorForDescriptor).forEach(allErrors::add);
        }
        return allErrors;
    }

    private boolean inputMediaTypeDefinedInAPISpec(APIOperationModel apiOperation) {
        return apiOperation.getInputMetadataModel().stream().anyMatch(x -> x.getMediaType() != null);
    }

    private boolean inputMediaTypeDefinedInAPISpec(APIModel apiModel, String path, String method) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().equalsIgnoreCase(method)).flatMap(x -> x.getInputMetadataModel().stream()).anyMatch(x -> x.getMediaType() != null);
    }

    private boolean inputMediaTypeDefinedInDescriptor(APIOperationModel apiOperationModel, ConnectorDescriptor descriptor) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(descriptor, apiOperationModel);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getInputMediaType());
    }

    private ValidationError getValidationErrorForApiSpec(APIOperationModel apiOperationModel, ConnectorDescriptor connectorDescriptor) {
        DescriptorElement descriptorElement = ValidationUtils.getClosestDescriptorElement(connectorDescriptor, apiOperationModel);
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().toUpperCase() + " defined in the API spec does not declare a media type for its input type and it is not defined in the Connector Descriptor";
        return new ValidationError(this, detail, descriptorElement.getLocation());
    }

    private ValidationError getValidationErrorForDescriptor(OperationDescriptor operationDescriptor) {
        return new ValidationError(this, "", operationDescriptor.getLocation());
    }
}

