/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.List;
import java.util.stream.Collectors;

public class NotSupportedSecuritySchemeRule
extends PreValidationRule {
    public NotSupportedSecuritySchemeRule() {
        super("The API spec defines a security scheme that is not supported", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().flatMap(apiOp -> apiOp.getSecuritySchemesModel().stream()).filter(securityScheme -> securityScheme.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED)).map(APISecuritySchemeModel::getName).distinct().map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationError getValidationError(String securitySchemeName) {
        String detail = "Security scheme '" + securitySchemeName + "' type is not supported";
        return new ValidationError(this, detail, DescriptorElementLocation.builder().empty());
    }
}

