/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueResolverReferenceArgumentsHaveValidFormatRule
extends PreValidationRule {
    private static final Pattern PATTERN = Pattern.compile("^(?:uriParameter\\.|queryParameter\\.|header\\.)\\S+$");

    public ValueResolverReferenceArgumentsHaveValidFormatRule() {
        super("Value Resolver arguments must respect the valid format (i.e. uriParameter.X, queryParameter.X or header.X)", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                if (operation.getExpects() == null) continue;
                validationErrors.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getUriParameter(), connectorDescriptor.getValueResolvers()));
                validationErrors.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getQueryParameter(), connectorDescriptor.getValueResolvers()));
                validationErrors.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getHeader(), connectorDescriptor.getValueResolvers()));
            }
        }
        return validationErrors;
    }

    private List<ValidationError> validateOperationParameters(EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, List<ParameterDescriptor> parameterDescriptors, List<ValueResolverDescriptor> valueResolverDescriptors) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        for (ParameterDescriptor parameter : parameterDescriptors) {
            if (parameter.getValueResolver() == null || parameter.getValueResolver().getArguments() == null || parameter.getValueResolver().getArguments().isEmpty() || valueResolverDescriptors.isEmpty() || valueResolverDescriptors.stream().noneMatch(x -> x.getName().equalsIgnoreCase(parameter.getValueResolver().getId()))) continue;
            validationErrors.addAll(parameter.getValueResolver().getArguments().stream().filter(x -> !this.validArgumentValueFormat(x.getValue())).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, parameter, (ValueResolverReferenceArgumentDescriptor)x)).collect(Collectors.toList()));
        }
        return validationErrors;
    }

    private boolean validArgumentValueFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return PATTERN.matcher(value).matches();
    }

    private ValidationError getValidationError(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ValueResolverReferenceArgumentDescriptor argument) {
        String detail = "'" + parameterDescriptor.getParamName() + "' parameter declared for the operation with PATH '" + endPointDescriptor.getPath() + "' and METHOD: '" + operationDescriptor.getMethod() + "' on the connector descriptor is declaring an invalid argument value for the argument '" + argument.getName() + "' : '" + argument.getValue() + "'";
        return new ValidationError(this, detail, argument.getLocation());
    }
}

