/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;

public class ValidationUtils {
    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, APIOperationModel apiOperationModel) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, apiOperationModel);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, apiOperationModel);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(connectorOperation.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, ConnectorOperation connectorOperation) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(connectorOperation.getHttpMethod())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, connectorOperation);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, connectorOperation);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static APIOperationModel getApiOperationModel(APIModel apiModel, ConnectorOperation connectorOperation) {
        return apiModel.getOperationsModel().stream().filter(x -> connectorOperation.getPath().equalsIgnoreCase(x.getPath())).filter(x -> connectorOperation.getHttpMethod().equalsIgnoreCase(x.getHttpMethod())).findFirst().orElse(null);
    }

    public static APIOperationModel getApiOperation(APIModel apiModel, TriggerDescriptor triggerDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(triggerDescriptor.getPath())).filter(x -> x.getHttpMethod().equalsIgnoreCase(triggerDescriptor.getMethod().getName())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperation.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperation.getHttpMethod())).findFirst().orElse(null);
    }
}

