/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import static com.mulesoft.connectivity.rest.sdk.internal.templating.TemplateEntity.getTemplateEngine;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.internal.util.AMFWrapper;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser;

import java.io.File;
import java.nio.file.Path;

public class RestSdk {

  private RestSdk() {}

  public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, String rootDir,
                                                 RestSdkRunConfiguration runConfiguration)
      throws ModelGenerationException {
    AMFWrapper.initialize();

    ValidationEngine validationEngine = new ValidationEngine();

    DescriptorParser descriptorParser = new DescriptorParser();
    ConnectorDescriptor connectorDescriptor = descriptorParser.parseConnectorDescriptor(descriptor);

    APIModel apiModel = ApiParser.parseModel(spec, format, rootDir, runConfiguration.skipValidations());

    boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);

    try {
      ConnectorModelBuilder connectorModelBuilder = new ConnectorModelBuilder();
      ConnectorModel connectorModel = connectorModelBuilder.buildConnectorModel(apiModel, connectorDescriptor);

      if (preValidationSuccess && validationEngine.postValidate(connectorModel)) {
        return connectorModel;
      } else {
        throw new ModelGenerationException("There are validation errors");
      }
    } catch (Exception e) {
      if (preValidationSuccess) {
        throw e;
      } else {
        throw new ModelGenerationException("There are validation errors");
      }
    }
  }

  public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir,
                                       Path descriptorPath, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath, runConfiguration).applyTemplates();
  }
}
