/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static org.apache.commons.lang.StringUtils.isNotBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.isXmlSchema;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.TypeSchemaPool;

public class ConnectorTypeSchemaBuilder {

  private final TypeSchemaPool typeSchemaPool;

  public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
    this.typeSchemaPool = typeSchemaPool;
  }

  public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) {
    if (apiTypeSchemaModel == null) {
      return null;
    }

    return getUniqueTypeSchema(apiTypeSchemaModel.getTypeSchema());
  }

  public TypeSchema buildTypeSchema(String rawSchema) {
    if (isXmlSchema(rawSchema)) {
      return getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
    } else {
      return getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }
  }

  private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
    if (typeSchema != null && isNotBlank(typeSchema.getRawSchema())) {
      return typeSchemaPool.getUniqueTypeSchema(typeSchema);
    }

    return typeSchema;
  }
}
