/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination;

import java.util.List;

public class Pagination {

  private final String name;
  private final String type;
  private final List<PaginationParameter> parameters;

  public Pagination(String name, String type, List<PaginationParameter> parameters) {
    this.name = name;
    this.type = type;
    this.parameters = parameters;
  }

  public String getName() {
    return name;
  }

  public String getType() {
    return type;
  }

  public boolean containsParameterExternalName(String name) {
    return parameters.stream()
        .filter(x -> x instanceof OutPaginationParameter)
        .anyMatch(x -> ((OutPaginationParameter) x).getValue().equalsIgnoreCase(name));
  }

  public PaginationParameter getParameter(String name) {
    return parameters.stream().filter(x -> x.name.equalsIgnoreCase(name)).findFirst().orElse(null);
  }

  public int getParametersSize() {
    return parameters.size();
  }
}
