/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.List;

public class Trigger {

  private final String internalName;
  private final String name;
  private final String displayName;
  private final String description;

  private final String itemsExpression;
  private final String identityExpression;
  private final String requestBodyExpression;

  private final String watermarkExpression;
  private final ParameterDataType watermarkType;

  private final List<TriggerParameter> parameters;
  private final List<ParameterBinding> parameterBindings;

  private final TypeDefinition triggerOutputType;

  private final ConnectorOperation operation;

  private boolean sampleData;

  public Trigger(String name,
                 String displayName,
                 String description,
                 String itemsExpression,
                 String identityExpression,
                 String requestBodyExpression,
                 String watermarkExpression,
                 ParameterDataType watermarkType,
                 List<TriggerParameter> parameters,
                 List<ParameterBinding> parameterBindings,
                 TypeDefinition triggerOutputType,
                 ConnectorOperation operation) {

    this.internalName = getXmlName(name);

    this.name = name;
    this.displayName = displayName;
    this.description = description;
    this.itemsExpression = itemsExpression;
    this.identityExpression = identityExpression;
    this.requestBodyExpression = requestBodyExpression;
    this.watermarkExpression = watermarkExpression;
    this.watermarkType = watermarkType;
    this.parameters = parameters;
    this.parameterBindings = parameterBindings;

    this.triggerOutputType = triggerOutputType;

    this.operation = operation;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getName() {
    return name;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getDescription() {
    return description;
  }

  public String getItemsExpression() {
    return itemsExpression;
  }

  public String getIdentityExpression() {
    return identityExpression;
  }

  public String getWatermarkExpression() {
    return watermarkExpression;
  }

  public ParameterDataType getWatermarkType() {
    return watermarkType;
  }

  public List<TriggerParameter> getParameters() {
    return parameters;
  }

  public List<ParameterBinding> getParameterBindings() {
    return parameterBindings;
  }

  public ConnectorOperation getOperation() {
    return operation;
  }

  public String getRequestBodyExpression() {
    return requestBodyExpression;
  }

  public TypeDefinition getTriggerOutputType() {
    return triggerOutputType;
  }

  public boolean getSampleData() {
    return sampleData;
  }

  public void setSampleData(boolean sampleData) {
    this.sampleData = sampleData;
  }
}
