/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

public class ConnectorDescriptor extends DescriptorElement {

  private final APISpecDescriptor apiSpec;
  private final String connectorName;
  private final String connectorDescription;
  private final MavenGavDescriptor connectorGav;
  private final BaseUriDescriptor baseUri;
  private final List<PaginationDeclarationDescriptor> paginations;
  private final List<EndPointDescriptor> endpoints;
  private final List<SecuritySchemeDescriptor> security;
  private final String connectorCategory;
  private final String baseJavaPackage;
  private final String extensionXml;
  private final Boolean skipOutputTypeValidation;
  private final String defaultInputMediaType;
  private final String defaultOutputMediaType;
  private final String queryParamArrayFormat;
  private final TestConnectionDescriptor testConnection;
  private final List<TriggerDescriptor> triggers;
  private final List<ValueResolverDescriptor> valueResolvers;

  public ConnectorDescriptor(APISpecDescriptor apiSpec, String connectorName, String connectorDescription,
                             MavenGavDescriptor connectorGav, BaseUriDescriptor baseUri,
                             List<EndPointDescriptor> endpoints,
                             List<PaginationDeclarationDescriptor> paginations,
                             List<SecuritySchemeDescriptor> security,
                             String connectorCategory,
                             String baseJavaPackage,
                             String extensionXml,
                             Boolean skipOutputTypeValidation,
                             String defaultInputMediaType,
                             String defaultOutputMediaType,
                             String queryParamArrayFormat,
                             TestConnectionDescriptor testConnection,
                             List<TriggerDescriptor> triggers,
                             List<ValueResolverDescriptor> valueResolvers) {

    this.apiSpec = apiSpec;
    this.connectorName = connectorName;
    this.connectorDescription = connectorDescription;
    this.connectorGav = connectorGav;
    this.baseUri = baseUri;
    this.paginations = paginations;
    this.endpoints = endpoints;
    this.security = security;
    this.connectorCategory = connectorCategory;
    this.baseJavaPackage = baseJavaPackage;
    this.extensionXml = extensionXml;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.defaultInputMediaType = defaultInputMediaType;
    this.defaultOutputMediaType = defaultOutputMediaType;
    this.queryParamArrayFormat = queryParamArrayFormat;
    this.testConnection = testConnection;
    this.triggers = triggers;
    this.valueResolvers = valueResolvers;
  }

  public APISpecDescriptor getApiSpec() {
    return apiSpec;
  }

  public String getConnectorName() {
    return connectorName;
  }

  public String getConnectorDescription() {
    return connectorDescription;
  }

  public MavenGavDescriptor getConnectorGav() {
    return connectorGav;
  }

  public BaseUriDescriptor getBaseUri() {
    return baseUri;
  }

  public List<PaginationDeclarationDescriptor> getPaginations() {
    return paginations;
  }

  public List<EndPointDescriptor> getEndpoints() {
    return endpoints;
  }

  public List<SecuritySchemeDescriptor> getSecurity() {
    return security;
  }

  public String getConnectorCategory() {
    return connectorCategory;
  }

  public String getBaseJavaPackage() {
    return baseJavaPackage;
  }

  public String getExtensionXml() {
    return extensionXml;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public String getDefaultInputMediaType() {
    return defaultInputMediaType;
  }

  public String getDefaultOutputMediaType() {
    return defaultOutputMediaType;
  }

  public String getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }

  public TestConnectionDescriptor getTestConnection() {
    return testConnection;
  }

  public List<TriggerDescriptor> getTriggers() {
    return triggers;
  }

  public List<ValueResolverDescriptor> getValueResolvers() {
    return valueResolvers;
  }
}
