/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import org.apache.commons.lang3.StringUtils;

public enum DataTypeDescriptor {
  STRING("string"), INTEGER("integer"), NUMBER("number"), ZONED_DATE_TIME("zonedDateTime"), LOCAL_DATE_TIME(
      "localDateTime"), BOOLEAN(
          "boolean");

  private final String name;

  DataTypeDescriptor(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static DataTypeDescriptor forName(String name) {
    if (StringUtils.isBlank(name)) {
      return null;
    }

    if (name.equalsIgnoreCase(STRING.getName())) {
      return STRING;
    } else if (name.equalsIgnoreCase(INTEGER.getName())) {
      return INTEGER;
    } else if (name.equalsIgnoreCase(NUMBER.getName())) {
      return NUMBER;
    } else if (name.equalsIgnoreCase(ZONED_DATE_TIME.getName())) {
      return ZONED_DATE_TIME;
    } else if (name.equalsIgnoreCase(LOCAL_DATE_TIME.getName())) {
      return LOCAL_DATE_TIME;
    } else if (name.equalsIgnoreCase(BOOLEAN.getName())) {
      return BOOLEAN;
    }

    throw new IllegalArgumentException("Data Type not supported: '" + name + "'");
  }
}
