/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

public class EndPointDescriptor extends DescriptorElement {

  private final String path;
  private final List<OperationDescriptor> operations;
  private final Boolean ignored;
  private final String baseUri;

  public EndPointDescriptor(String path, List<OperationDescriptor> operations, Boolean ignored, String alternativeBaseUri) {
    this.path = path;
    this.operations = operations;
    this.ignored = ignored;
    this.baseUri = alternativeBaseUri;
  }

  public String getPath() {
    return path;
  }

  public List<OperationDescriptor> getOperations() {
    return operations;
  }

  public Boolean isIgnored() {
    return ignored;
  }

  public String getBaseUri() {
    return baseUri;
  }
}
