/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import org.apache.commons.lang3.StringUtils;

public enum HttpMethodDescriptor {
  GET("get"), POST("post"), PUT("put"), PATCH("patch"), DELETE("delete"), HEAD("head"), OPTIONS("options");

  private final String name;

  HttpMethodDescriptor(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static HttpMethodDescriptor forName(String name) {
    if (StringUtils.isBlank(name)) {
      return null;
    }

    if (name.equalsIgnoreCase(GET.getName())) {
      return GET;
    } else if (name.equalsIgnoreCase(POST.getName())) {
      return POST;
    } else if (name.equalsIgnoreCase(PUT.getName())) {
      return PUT;
    } else if (name.equalsIgnoreCase(PATCH.getName())) {
      return PATCH;
    } else if (name.equalsIgnoreCase(DELETE.getName())) {
      return DELETE;
    } else if (name.equalsIgnoreCase(HEAD.getName())) {
      return HEAD;
    } else if (name.equalsIgnoreCase(OPTIONS.getName())) {
      return OPTIONS;
    }

    throw new IllegalArgumentException("HTTP Method not supported: " + name);
  }
}
