/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

public class PaginationDeclarationDescriptor extends DescriptorElement {

  private final String name;
  private final String type;
  private final List<PaginationParameterDescriptor> parameters;

  public PaginationDeclarationDescriptor(String name, String type, List<PaginationParameterDescriptor> parameters) {
    this.name = name;
    this.type = type;
    this.parameters = parameters;
  }

  public String getName() {
    return name;
  }

  public String getType() {
    return type;
  }

  public List<PaginationParameterDescriptor> getParameters() {
    return parameters;
  }
}
