/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

public class ParameterDescriptor extends DescriptorElement {

  private final String friendlyName;
  private final String paramName;
  private final String description;
  private final boolean ignored;
  private final ValueResolverReferenceDescriptor valueResolver;

  public ParameterDescriptor(String friendlyName, String paramName, String description, boolean ignored,
                             ValueResolverReferenceDescriptor valueResolver) {
    this.friendlyName = friendlyName;
    this.paramName = paramName;
    this.description = description;
    this.ignored = ignored;
    this.valueResolver = valueResolver;
  }

  public String getFriendlyName() {
    return friendlyName;
  }

  public String getParamName() {
    return paramName;
  }

  public String getDescription() {
    return description;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public ValueResolverReferenceDescriptor getValueResolver() {
    return valueResolver;
  }
}
