/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import org.apache.commons.lang3.StringUtils;

public enum SampleDataTypeDescriptor {
  SAME_OPERATION("same-operation");

  private final String name;

  SampleDataTypeDescriptor(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static SampleDataTypeDescriptor forName(String name) {
    if (StringUtils.isBlank(name)) {
      return null;
    }

    if (name.equalsIgnoreCase(SAME_OPERATION.getName())) {
      return SAME_OPERATION;
    }
    throw new IllegalArgumentException("Sample Data Type not supported: '" + name + "'");
  }
}
