/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;
import java.util.Set;

/**
 * Descriptor element that allows defining how the connection validation must be done for the generated connector.
 */
public class TestConnectionDescriptor extends DescriptorElement {

  private final String path;
  private final String method;
  private final Set<String> validStatusCodes;
  private final String mediaType;
  private final List<TestConnectionResponseValidationDescriptor> responseValidation;

  public TestConnectionDescriptor(String path, String method, Set<String> validStatusCodes, String mediaType,
                                  List<TestConnectionResponseValidationDescriptor> responseValidation) {
    this.path = path;
    this.method = method;
    this.validStatusCodes = validStatusCodes;
    this.mediaType = mediaType;
    this.responseValidation = responseValidation;
  }

  public String getPath() {
    return path;
  }

  public String getMethod() {
    return method;
  }

  public Set<String> getValidStatusCodes() {
    return validStatusCodes;
  }

  public String getMediaType() {
    return mediaType;
  }

  public List<TestConnectionResponseValidationDescriptor> getResponseValidation() {
    return responseValidation;
  }
}
