/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

public class TriggerParameterBindingsDescriptor {

  private final List<TriggerParameterBindingDescriptor> uriParameters;
  private final List<TriggerParameterBindingDescriptor> queryParameters;
  private final List<TriggerParameterBindingDescriptor> headers;
  private final String requestBodyExpression;

  public TriggerParameterBindingsDescriptor(List<TriggerParameterBindingDescriptor> uriParameters,
                                            List<TriggerParameterBindingDescriptor> queryParameters,
                                            List<TriggerParameterBindingDescriptor> headers,
                                            String requestBodyExpression) {
    this.uriParameters = uriParameters;
    this.queryParameters = queryParameters;
    this.headers = headers;
    this.requestBodyExpression = requestBodyExpression;
  }

  public List<TriggerParameterBindingDescriptor> getUriParameters() {
    return uriParameters;
  }

  public List<TriggerParameterBindingDescriptor> getQueryParameters() {
    return queryParameters;
  }

  public List<TriggerParameterBindingDescriptor> getHeaders() {
    return headers;
  }

  public String getRequestBodyExpression() {
    return requestBodyExpression;
  }
}
