/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

/**
 * Descriptor element that allows defining an instance of a value resolver that must be generated in the connector.
 */
public class ValueResolverDescriptor extends DescriptorElement {

  private final String name;
  private final String path;
  private final HttpMethodDescriptor method;
  private final ValueResolverItemsDescriptor items;
  private final List<ValueResolverParameterDescriptor> parameters;
  private final ValueResolverBindingDescriptor binding;

  public ValueResolverDescriptor(String name, String path,
                                 HttpMethodDescriptor method,
                                 ValueResolverItemsDescriptor items,
                                 List<ValueResolverParameterDescriptor> parameters,
                                 ValueResolverBindingDescriptor binding) {
    this.name = name;
    this.path = path;
    this.method = method;
    this.items = items;
    this.parameters = parameters;
    this.binding = binding;
  }

  public String getName() {
    return name;
  }

  public String getPath() {
    return path;
  }

  public HttpMethodDescriptor getMethod() {
    return method;
  }

  public ValueResolverItemsDescriptor getItems() {
    return items;
  }

  public List<ValueResolverParameterDescriptor> getParameters() {
    return parameters;
  }

  public ValueResolverBindingDescriptor getBinding() {
    return binding;
  }
}
