/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APISpecDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APIUrlDescriptor;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorApiSpecParser {

  private final static String REST_SDK_API_SPEC = "http://a.ml/vocabularies/rest-sdk#webAPISpecAsset";
  private final static String REST_SDK_API_SPEC_URL = "http://anypoint.com/vocabs/digital-repository#webAPISpecAssetURL";

  private static final DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();

  public APISpecDescriptor parseApiSpec(DialectDomainElement encodes) {
    DialectDomainElement apiSpecElement = parseApiSpecElement(encodes);

    if (apiSpecElement == null) {
      return null;
    }

    String url = parseUrl(apiSpecElement);

    if (isNotBlank(url)) {
      return new APIUrlDescriptor(url);
    } else {
      return descriptorMavenGavParser.parseMavenGav(apiSpecElement);
    }
  }

  public DialectDomainElement parseApiSpecElement(DialectDomainElement encodes) {
    List<DialectDomainElement> apiSpecElements = encodes.getObjectPropertyUri(REST_SDK_API_SPEC);
    return apiSpecElements.isEmpty() ? null : apiSpecElements.get(0);
  }

  public String parseUrl(DialectDomainElement apiSpecElement) {
    List<Object> groupIds = apiSpecElement.getScalarByPropertyUri(REST_SDK_API_SPEC_URL);
    return groupIds.isEmpty() ? null : groupIds.get(0).toString();
  }

}
