/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;

import java.util.List;

import javax.validation.constraints.NotNull;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorExpressionParser {

  private static final String REST_SDK_EXPRESSION_LANGUAGE = "http://a.ml/vocabularies/rest-sdk#expressionLanguage";
  private static final String REST_SDK_EXPRESSION_CONTENT = "http://a.ml/vocabularies/rest-sdk#expressionContent";

  public ExpressionDescriptor parseExpression(DialectDomainElement expressionElement) {
    if (expressionElement == null) {
      return null;
    }

    return new ExpressionDescriptor(
                                    parseLanguage(expressionElement),
                                    parseContent(expressionElement));
  }

  private String parseLanguage(@NotNull DialectDomainElement expressionElement) {
    List<Object> expressionLanguage = expressionElement.getScalarByPropertyUri(REST_SDK_EXPRESSION_LANGUAGE);

    return expressionLanguage.isEmpty() ? null : expressionLanguage.get(0).toString();
  }

  public String parseContent(@NotNull DialectDomainElement expressionElement) {
    List<Object> expressionContent = expressionElement.getScalarByPropertyUri(REST_SDK_EXPRESSION_CONTENT);

    return expressionContent.isEmpty() ? null : expressionContent.get(0).toString();
  }
}
