/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractParamName;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseCoreDescription;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseInputMediaType;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseInputTypeSchema;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleBooleanProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleStringProperty;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorPartParser {

  private static final String REST_SDK_FRIENDLY_NAME = "http://a.ml/vocabularies/rest-sdk#friendlyName";
  private static final String REST_SDK_FILE_PART = "http://a.ml/vocabularies/rest-sdk#filePart";


  public List<PartDescriptor> parseParts(List<DialectDomainElement> parameterElements, Path descriptorFilePath) {

    List<PartDescriptor> parts = new ArrayList<>();
    for (DialectDomainElement p : parameterElements) {
      parts.add(parsePart(p, descriptorFilePath));
    }

    return parts;
  }

  private PartDescriptor parsePart(DialectDomainElement partElement, Path descriptorFilePath) {
    return new PartDescriptor(getPartName(partElement),
                              getFriendlyName(partElement),
                              getDescription(partElement),
                              parseInputTypeSchema(partElement, descriptorFilePath),
                              parseInputMediaType(partElement),
                              getFilePart(partElement));
  }

  private String getPartName(DialectDomainElement partElement) {
    return parseApiContractParamName(partElement);
  }

  private String getFriendlyName(DialectDomainElement partElement) {
    return parseSingleStringProperty(partElement, REST_SDK_FRIENDLY_NAME);
  }

  private String getDescription(DialectDomainElement partElement) {
    return parseCoreDescription(partElement);
  }

  private boolean getFilePart(DialectDomainElement partElement) {
    return parseSingleBooleanProperty(partElement, REST_SDK_FILE_PART);
  }
}
