/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleStringProperty;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataTypeDescriptor;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorSampleDataParser {

  private static final String REST_SDK_SAMPLE_DATA = "http://a.ml/vocabularies/rest-sdk#sampleData";
  private static final String REST_SDK_SAMPLE_DATA_TYPE = "http://a.ml/vocabularies/rest-sdk#sampleDataType";

  public SampleDataDescriptor parseRequest(DialectDomainElement operationElement) {
    DialectDomainElement sampleDataElement = parseSampleDataElement(operationElement);

    if (sampleDataElement == null) {
      return null;
    }

    SampleDataTypeDescriptor sampleDataTypeDescriptor = parseSampleDataType(sampleDataElement);
    return new SampleDataDescriptor(sampleDataTypeDescriptor);
  }

  private SampleDataTypeDescriptor parseSampleDataType(DialectDomainElement parameterDescriptor) {
    return SampleDataTypeDescriptor.forName(parseSingleStringProperty(parameterDescriptor, REST_SDK_SAMPLE_DATA_TYPE));
  }

  private DialectDomainElement parseSampleDataElement(DialectDomainElement operationElement) {
    return getSingleObjectProperty(operationElement, REST_SDK_SAMPLE_DATA);
  }
}
