/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingsDescriptor;

import java.util.LinkedList;
import java.util.List;

import static java.util.Collections.emptyList;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.*;

public class DescriptorTriggerParameterBindingParser {

  private static final String API_CONTRACT_URI_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#uriParameter";
  private static final String API_CONTRACT_QUERY_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#queryParameter";
  private static final String API_CONTRACT_HEADER = "http://a.ml/vocabularies.rest.sdk/apiContract#header";
  private static final String REQUEST_BODY_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#triggerRequestBodyBinding";

  private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

  public TriggerParameterBindingsDescriptor parseParameterBindings(DialectDomainElement triggerParameterBindingDescriptor) {
    if (triggerParameterBindingDescriptor == null) {
      return null;
    }

    return new TriggerParameterBindingsDescriptor(
                                                  parseBindings(triggerParameterBindingDescriptor
                                                      .getObjectPropertyUri(API_CONTRACT_URI_PARAMETER)),
                                                  parseBindings(triggerParameterBindingDescriptor
                                                      .getObjectPropertyUri(API_CONTRACT_QUERY_PARAMETER)),
                                                  parseBindings(triggerParameterBindingDescriptor
                                                      .getObjectPropertyUri(API_CONTRACT_HEADER)),
                                                  parseRequestBodyExpression(triggerParameterBindingDescriptor));
  }

  private String parseRequestBodyExpression(DialectDomainElement triggerParameterBindingDescriptor) {
    DialectDomainElement requestBodyExpression =
        getSingleObjectProperty(triggerParameterBindingDescriptor, REQUEST_BODY_EXPRESSION);

    if (requestBodyExpression == null) {
      return null;
    }

    return expressionParser.parseExpression(requestBodyExpression).getExpression();
  }

  private List<TriggerParameterBindingDescriptor> parseBindings(List<DialectDomainElement> parameterBindingDescriptors) {
    if (parameterBindingDescriptors == null || parameterBindingDescriptors.isEmpty()) {
      return emptyList();
    }

    List<TriggerParameterBindingDescriptor> result = new LinkedList<>();

    for (DialectDomainElement binding : parameterBindingDescriptors) {
      result.add(parseBinding(binding));
    }

    return result;
  }

  private TriggerParameterBindingDescriptor parseBinding(DialectDomainElement binding) {
    return new TriggerParameterBindingDescriptor(
                                                 parseApiContractParamName(binding),
                                                 expressionParser.parseContent(binding));
  }
}
