/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;

import java.util.LinkedList;
import java.util.List;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractParamName;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseCoreDescription;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseFriendlyName;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseParameterType;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseRequired;
import static java.util.Collections.emptyList;

public class DescriptorTriggerParametersParser {

  public List<TriggerParameterDescriptor> parseParameters(List<DialectDomainElement> triggerParameterDescriptors) {
    if (triggerParameterDescriptors == null) {
      return emptyList();
    }

    List<TriggerParameterDescriptor> result = new LinkedList<>();
    for (DialectDomainElement parameterDescriptor : triggerParameterDescriptors) {
      result.add(parseParameter(parameterDescriptor));
    }
    return result;
  }

  private TriggerParameterDescriptor parseParameter(DialectDomainElement parameterDescriptor) {
    return new TriggerParameterDescriptor(
                                          parseApiContractParamName(parameterDescriptor),
                                          parseFriendlyName(parameterDescriptor),
                                          parseCoreDescription(parameterDescriptor),
                                          parseParameterType(parameterDescriptor),
                                          parseRequired(parameterDescriptor));
  }
}
