/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractParamName;
import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingParameterDescriptor;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorValueResolverBindingParser {

  private static final String AML_REST_SDK_VALUE_RESOLVER_BINDING = "http://a.ml/vocabularies/rest-sdk#valueResolverBinding";
  private static final String API_CONTRACT_URI_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#uriParameter";
  private static final String API_CONTRACT_QUERY_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#queryParameter";
  private static final String API_CONTRACT_HEADER = "http://a.ml/vocabularies.rest.sdk/apiContract#header";
  private static final String AML_REST_SDK_VALUE_RESOLVER_BINDING_PARAMETER_VALUE =
      "http://a.ml/vocabularies/rest-sdk#valueResolverBindingParameterValue";

  private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

  public ValueResolverBindingDescriptor parseBinding(DialectDomainElement valueResolver) {
    DialectDomainElement bindingElement =
        DescriptorParserUtils.getSingleObjectProperty(valueResolver, AML_REST_SDK_VALUE_RESOLVER_BINDING);

    if (bindingElement == null) {
      return null;
    }

    return new ValueResolverBindingDescriptor(
                                              parseBindingParameters(bindingElement
                                                  .getObjectPropertyUri(API_CONTRACT_URI_PARAMETER)),
                                              parseBindingParameters(bindingElement
                                                  .getObjectPropertyUri(API_CONTRACT_QUERY_PARAMETER)),
                                              parseBindingParameters(bindingElement
                                                  .getObjectPropertyUri(API_CONTRACT_HEADER)));
  }

  private List<ValueResolverBindingParameterDescriptor> parseBindingParameters(List<DialectDomainElement> parameterElements) {
    if (parameterElements == null || parameterElements.isEmpty()) {
      return emptyList();
    }

    return parameterElements.stream().map(this::parseBindingParameter).collect(toList());
  }

  private ValueResolverBindingParameterDescriptor parseBindingParameter(DialectDomainElement parameterElement) {
    return new ValueResolverBindingParameterDescriptor(
                                                       parseApiContractParamName(parameterElement),
                                                       parseBindingParameterValue(parameterElement));
  }

  private ExpressionDescriptor parseBindingParameterValue(DialectDomainElement parameterElement) {

    DialectDomainElement bindingParameterValueElement =
        getSingleObjectProperty(parameterElement, AML_REST_SDK_VALUE_RESOLVER_BINDING_PARAMETER_VALUE);

    return expressionParser.parseExpression(bindingParameterValueElement);
  }
}
