/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverItemsDescriptor;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorValueResolverItemsParser {

  private static final String AML_REST_SDK_VALUE_RESOLVER_ITEMS = "http://a.ml/vocabularies/rest-sdk#valueResolverItems";
  private static final String AML_REST_SDK_VALUE_RESOLVER_ITEMS_EXTRACTION =
      "http://a.ml/vocabularies/rest-sdk#valueResolverItemExtraction";
  private static final String AML_REST_SDK_VALUE_RESOLVER_ITEMS_VALUE =
      "http://a.ml/vocabularies/rest-sdk#valueResolverItemValue";
  private static final String AML_REST_SDK_VALUE_RESOLVER_ITEMS_DISPLAY_NAME =
      "http://a.ml/vocabularies/rest-sdk#valueResolverItemDisplayName";

  private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

  public ValueResolverItemsDescriptor parseItems(DialectDomainElement valueResolver) {
    final DialectDomainElement itemsElement = valueResolver.getObjectPropertyUri(AML_REST_SDK_VALUE_RESOLVER_ITEMS).get(0);

    return new ValueResolverItemsDescriptor(
                                            getElementExpression(itemsElement, AML_REST_SDK_VALUE_RESOLVER_ITEMS_EXTRACTION),
                                            getElementExpression(itemsElement, AML_REST_SDK_VALUE_RESOLVER_ITEMS_VALUE),
                                            getElementExpression(itemsElement, AML_REST_SDK_VALUE_RESOLVER_ITEMS_DISPLAY_NAME));
  }

  private ExpressionDescriptor getElementExpression(DialectDomainElement itemsElement,
                                                    String amlRestSdkValueResolverItemsExtraction) {
    final DialectDomainElement expressionElement =
        getSingleObjectProperty(itemsElement, amlRestSdkValueResolverItemsExtraction);

    return expressionParser.parseExpression(expressionElement);
  }
}
