/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractParamName;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseParameterType;
import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverParameterDescriptor;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorValueResolverParametersParser {

  private static final String AML_REST_SDK_VALUE_RESOLVER_PARAMETERS =
      "http://a.ml/vocabularies/rest-sdk#valueResolverParameters";

  public List<ValueResolverParameterDescriptor> parseParameters(DialectDomainElement valueResolver) {
    List<DialectDomainElement> parameters = valueResolver.getObjectPropertyUri(AML_REST_SDK_VALUE_RESOLVER_PARAMETERS);

    if (parameters == null) {
      return emptyList();
    }

    return parameters.stream().map(this::parseParameter).collect(toList());
  }

  public ValueResolverParameterDescriptor parseParameter(DialectDomainElement parameter) {
    return new ValueResolverParameterDescriptor(parseApiContractParamName(parameter),
                                                parseParameterType(parameter));
  }
}
