/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractMethodAsMethodDescriptor;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractPath;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseCoreName;
import static java.util.Collections.emptyList;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;

import java.util.LinkedList;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorValueResolverParser {

  private static final String AML_REST_SDK_VALUE_RESOLVERS = "http://a.ml/vocabularies/rest-sdk#valueResolvers";

  private static final DescriptorValueResolverItemsParser valueResolverItemsParser = new DescriptorValueResolverItemsParser();
  private static final DescriptorValueResolverBindingParser valueResolverBindingParser =
      new DescriptorValueResolverBindingParser();
  private static final DescriptorValueResolverParametersParser valueResolverParametersParser =
      new DescriptorValueResolverParametersParser();

  public List<ValueResolverDescriptor> parseValueResolvers(DialectDomainElement encodes) {
    final List<DialectDomainElement> valueResolvers = encodes.getObjectPropertyUri(AML_REST_SDK_VALUE_RESOLVERS);

    if (valueResolvers == null) {
      return emptyList();
    }

    List<ValueResolverDescriptor> result = new LinkedList<>();
    for (DialectDomainElement valueResolver : valueResolvers) {
      result.add(parseValueResolver(valueResolver));
    }

    return result;
  }

  private ValueResolverDescriptor parseValueResolver(DialectDomainElement valueResolver) {
    return new ValueResolverDescriptor(
                                       parseCoreName(valueResolver),
                                       parseApiContractPath(valueResolver),
                                       parseApiContractMethodAsMethodDescriptor(valueResolver),
                                       valueResolverItemsParser.parseItems(valueResolver),
                                       valueResolverParametersParser.parseParameters(valueResolver),
                                       valueResolverBindingParser.parseBinding(valueResolver));
  }
}
