/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractParamName;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleStringProperty;
import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceDescriptor;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorValueResolverReferenceParser {

  private static final String REST_SDK_VALUE_RESOLVER_REFERENCE = "http://a.ml/vocabularies/rest-sdk#valueResolverReference";
  private static final String REST_SDK_VALUE_RESOLVER_REFERENCE_ID = "http://a.ml/vocabularies/rest-sdk#valueResolverReferenceId";

  private static final String REST_SDK_VALUE_RESOLVER_REFERENCE_ARGUMENTS =
      "http://a.ml/vocabularies/rest-sdk#valueResolverReferenceArguments";
  private static final String REST_SDK_VALUE_RESOLVER_REFERENCE_ARGUMENT_VALUE =
      "http://a.ml/vocabularies/rest-sdk#valueResolverArgumentValue";

  public ValueResolverReferenceDescriptor parseValueResolverReference(DialectDomainElement parameterElement) {
    DialectDomainElement valueResolverElement = getSingleObjectProperty(parameterElement, REST_SDK_VALUE_RESOLVER_REFERENCE);

    if (valueResolverElement == null) {
      return null;
    }

    return new ValueResolverReferenceDescriptor(
                                                parseSingleStringProperty(valueResolverElement,
                                                                          REST_SDK_VALUE_RESOLVER_REFERENCE_ID),
                                                parseArguments(valueResolverElement));
  }

  private List<ValueResolverReferenceArgumentDescriptor> parseArguments(DialectDomainElement valueResolverElement) {
    List<DialectDomainElement> objectPropertyUri =
        valueResolverElement.getObjectPropertyUri(REST_SDK_VALUE_RESOLVER_REFERENCE_ARGUMENTS);

    if (objectPropertyUri == null || objectPropertyUri.isEmpty()) {
      return emptyList();
    }

    return objectPropertyUri.stream().map(this::parseArgument).collect(toList());
  }

  private ValueResolverReferenceArgumentDescriptor parseArgument(DialectDomainElement argumentElement) {
    return new ValueResolverReferenceArgumentDescriptor(
                                                        parseApiContractParamName(argumentElement),
                                                        parseSingleStringProperty(argumentElement,
                                                                                  REST_SDK_VALUE_RESOLVER_REFERENCE_ARGUMENT_VALUE));
  }
}
