/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.templating.VelocityTemplateEntity;

import java.nio.file.Path;

public class SdkGitIgnore extends VelocityTemplateEntity {

  private static final String GITIGNORE_VM = "templates/sdk/gitignore.vm";

  public SdkGitIgnore(Path outputDir) {
    super(outputDir);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(GITIGNORE_VM, outputDir.resolve(".gitignore"));
  }
}
