/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.dynamic.FromJsonInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.dynamic.JsonInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.dynamic.XmlInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.util.FileGenerationUtils;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.FromJsonInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.JsonInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.StringInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.BooleanInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.DateOnlyInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.DateTimeInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.FileInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.IntegerInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.NumberInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.TimeOnlyInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.input.XmlInputMetadataResolver;

import java.nio.file.Path;

public class SdkInputMetadataResolver extends SdkAbstractStaticMetadataResolver {

  private String qName;

  public SdkInputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                  ConnectorOperation operation, TypeDefinition typeDefinition,
                                  FileGenerationUtils.SchemaNameType schemaNameType,
                                  String partName, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName, EMPTY, runConfiguration);
  }

  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
    TypeSchema typeSchema = typeDefinition.getTypeSchema();

    if (typeDefinition instanceof PrimitiveTypeDefinition) {
      return getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition) typeDefinition);
    } else if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(APPLICATION_XML_TYPE)) {
      qName = ((XmlTypeSchema) typeDefinition.getTypeSchema()).getElementName();

      return runConfiguration.useDynamicTypeResolvers() ? XmlInputDynamicMetadataResolver.class
          : XmlInputMetadataResolver.class;

    } else if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(APPLICATION_JSON_TYPE)) {

      return runConfiguration.useDynamicTypeResolvers() ? JsonInputDynamicMetadataResolver.class
          : JsonInputMetadataResolver.class;

    } else if (typeSchema instanceof CustomTypeSchema) {

      return runConfiguration.useDynamicTypeResolvers() ? FromJsonInputDynamicMetadataResolver.class
          : FromJsonInputMetadataResolver.class;
    }

    return StringInputMetadataResolver.class;
  }

  protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition)
      throws TemplatingException {
    PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
      return NumberInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
      return IntegerInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.STRING)) {
      return StringInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
      return BooleanInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.DATE_TIME)
        || primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
      return DateTimeInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
      return TimeOnlyInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY)
        || primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.DATE)) {
      return DateOnlyInputMetadataResolver.class;
    }

    if (primitiveType.equals(PrimitiveTypeDefinition.PrimitiveType.FILE)) {
      return FileInputMetadataResolver.class;
    }

    throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
  }

  @Override
  protected String getClassNameSuffix() {
    return "InputMetadataResolver";
  }

  @Override
  protected boolean requiresQNameMethod() {
    return superclass.equals(XmlInputMetadataResolver.class)
        || superclass.equals(XmlInputDynamicMetadataResolver.class);
  }

  @Override
  protected boolean requiresFormatMethod() {
    return superclass.equals(FromJsonInputMetadataResolver.class)
        || superclass.equals(FileInputMetadataResolver.class)
        || superclass.equals(FromJsonInputDynamicMetadataResolver.class);
  }

  @Override
  protected String getQName() {
    return qName;
  }

  @Override
  protected boolean requiresToWriteSchema() {
    return superclass.equals(FromJsonInputMetadataResolver.class)
        || superclass.equals(JsonInputMetadataResolver.class)
        || superclass.equals(XmlInputMetadataResolver.class)
        || superclass.equals(FromJsonInputDynamicMetadataResolver.class)
        || superclass.equals(JsonInputDynamicMetadataResolver.class)
        || superclass.equals(XmlInputDynamicMetadataResolver.class);
  }
}
