/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.OutPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationParameter;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.PageNumberPagingProvider;

import java.nio.file.Path;

public class SdkPageNumberPaginationOperation extends AbstractSdkPaginationOperation {

  public static final String PAGE_NUMBER_PARAM_NAME = "pageNumberParamName";
  public static final String INITIAL_PAGE_NUMBER = "initialPageNumber";

  public SdkPageNumberPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                          ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public String getInitialPagingParameterSummary() {
    return "The initial page to get in the first request";
  }

  @Override
  public Class getPagingProvider() {
    return PageNumberPagingProvider.class;
  }

  @Override
  public String getTokenParamName() {
    PaginationParameter parameter = getPagination().getParameter(PAGE_NUMBER_PARAM_NAME);

    return (parameter == null) ? null : ((OutPaginationParameter) parameter).getValue();
  }

  @Override
  public String getInitialParamName() {
    return INITIAL_PAGE_NUMBER;
  }
}
