/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.templating.VelocityTemplateEntity;

import java.nio.file.Path;

public class SdkPom extends VelocityTemplateEntity {

  private final static String POM_VM = "templates/sdk/pom.vm";
  private final ConnectorModel model;

  public SdkPom(Path outputDir, ConnectorModel model) {
    super(outputDir);
    this.model = model;
  }

  public String getName() {
    return model.getConnectorName();
  }

  public String getDescription() {
    return model.getApiDescription();
  }

  public String getMvnGroupId() {
    return model.getMvnGroupId();
  }

  public String getMvnArtifactId() {
    return isNotBlank(model.getMvnArtifactId()) ? model.getMvnArtifactId() : model.getConnectorXmlName();
  }

  public String getMvnVersion() {
    return model.getMvnVersion();
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(POM_VM, outputDir.resolve("pom.xml"));
  }
}
