/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.nio.file.Path;

public class SdkTriggerOutputMetadataResolver extends SdkOutputMetadataResolver {

  public SdkTriggerOutputMetadataResolver(Path outputDir,
                                          ConnectorModel connectorModel,
                                          SdkConnector sdkConnector,
                                          ConnectorOperation operation,
                                          TypeDefinition typeDefinition,
                                          String triggerName,
                                          RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, triggerName, runConfiguration);
  }

  @Override
  protected String getClassNameSuffix() {
    return "Trigger" + super.getClassNameSuffix();
  }
}
