/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;

public class SdkTypeDefinitionUtils {

  private SdkTypeDefinitionUtils() {}

  public static Type getJavaType(TypeDefinition typeDefinition) {
    if (typeDefinition instanceof PrimitiveTypeDefinition) {
      return getJavaPrimitiveType((PrimitiveTypeDefinition) typeDefinition);
    } else {
      return InputStream.class;
    }
  }

  private static Type getJavaPrimitiveType(PrimitiveTypeDefinition primitiveTypeDefinition) {
    switch (primitiveTypeDefinition.getPrimitiveType()) {
      case BOOLEAN:
        return boolean.class;
      case NUMBER:
        return Double.class;
      case INTEGER:
        return Integer.class;
      case DATE:
      case DATE_TIME:
      case DATE_ONLY:
      case DATE_TIME_ONLY:
      case TIME_ONLY:
        return Date.class;
      case FILE:
        return InputStream.class;
      case STRING:
        return String.class;
    }

    throw new IllegalArgumentException("PrimitiveTypeDefinition not supported : " + primitiveTypeDefinition.getPrimitiveType());
  }

}
