/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;

import java.util.LinkedList;
import java.util.List;

public class DescriptorPathMustExistInApiRule extends PreValidationRule {

  //R001
  public DescriptorPathMustExistInApiRule() {
    super("Descriptor PATHs must be present in the API spec",
          "Any path declared in the connector descriptor must be present in the API spec.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
    List<String> descriptorPaths =
        connectorDescriptor.getEndpoints().stream()
            .map(EndPointDescriptor::getPath)
            .collect(toList());

    List<String> apiPaths = apiModel.getOperationsModel().stream()
        .map(APIOperationModel::getPath)
        .distinct()
        .collect(toList());

    List<ValidationResult> validationResults = new LinkedList<>();

    for (String descriptorPath : descriptorPaths) {
      if (apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(descriptorPath))) {
        validationResults.add(new ValidationResult(this, "Path: " + descriptorPath));
      }
    }

    return validationResults;
  }
}
