/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

import java.util.LinkedList;
import java.util.List;

public class GavVersionMustBeValidRule extends PreValidationRule {

  //R009
  public GavVersionMustBeValidRule() {
    super("Descriptor connectorGav's version must ve a valid Maven version",
          "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String version = connectorDescriptor.getConnectorGav().getVersion();
    String validVersion = XmlUtils.removeMavenVersionUnwantedCharacters(version);

    if (!version.equalsIgnoreCase(validVersion)) {
      validationResults.add(getValidationError());
    }

    return validationResults;
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(this, "'version' property declared in the connector descriptor's 'connectorGav' property");
  }
}
