/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.isXmlSchema;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.SchemaShape;
import amf.client.model.domain.Shape;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeSchemaModel;

import javax.ws.rs.core.MediaType;

public class AMFTypeSchemaModel extends APITypeSchemaModel {

  public AMFTypeSchemaModel(AnyShape shape, MediaType mediaType) {
    this.typeSchema = buildTypeSchema(shape, mediaType);
  }

  private TypeSchema buildTypeSchema(AnyShape shape, MediaType mediaType) {

    TypeSchema newTypeSchema;

    if (isXmlSchemaShape(shape)) {
      newTypeSchema = buildXmlTypeSchema((SchemaShape) shape);
    }

    else if (isJsonSchemaShape(shape)) {
      newTypeSchema = new JsonTypeSchema(((SchemaShape) shape).raw().value());
    }

    else if (APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
      newTypeSchema = new JsonTypeSchema(new AMFTypeSchemaSupplier(shape, mediaType));
    }

    else if (APPLICATION_XML_TYPE.isCompatible(mediaType)) {
      newTypeSchema = new XmlTypeSchema(new AMFTypeSchemaSupplier(shape, mediaType));
    }

    else {
      newTypeSchema = new CustomTypeSchema(new AMFTypeSchemaSupplier(shape, mediaType), mediaType);
    }

    return newTypeSchema;
  }

  public static boolean isJsonSchemaShape(Shape shape) {
    if (!(shape instanceof SchemaShape)) {
      return false;
    }

    SchemaShape schemaShape = (SchemaShape) shape;

    return schemaShape.raw().nonEmpty() && !isXmlSchema(schemaShape.raw().value());
  }

  public static boolean isXmlSchemaShape(Shape shape) {
    if (!(shape instanceof SchemaShape)) {
      return false;
    }

    SchemaShape schemaShape = (SchemaShape) shape;

    return schemaShape.raw().nonEmpty() && isXmlSchema(schemaShape.raw().value());
  }

  private TypeSchema buildXmlTypeSchema(SchemaShape schemaShape) {

    String elementName = schemaShape.annotations().fragmentName().orElse(null);
    String path = schemaShape.location().orElse(null);

    return new XmlTypeSchema(schemaShape.raw().value(), elementName, path);
  }
}
