/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.api.DescriptorMode;
import com.mulesoft.connectivity.rest.sdk.api.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorPackage;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APISpecDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APIUrlDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.writer.DescriptorWriter;
import com.mulesoft.connectivity.rest.sdk.internal.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFAPIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class DescriptorScaffolder {
    private static final String DEFAULT_MVN_GROUP_ID = "com.mulesoft.connectors";
    private static final String DEFAULT_MVN_VERSION = "1.0.0-SNAPSHOT";
    private static final String DESCRIPTOR_FILE_NAME = "descriptor.yaml";

    private DescriptorScaffolder() {
    }

    public static void scaffoldDescriptor(File spec, SpecFormat format, Path outputDir, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException, IOException {
        ConnectorDescriptor connectorDescriptor = DescriptorScaffolder.scaffoldDescriptorModel(spec, format, descriptorMode, skipValidation);
        DescriptorScaffolder.writeToYaml(connectorDescriptor, outputDir);
    }

    public static ConnectorDescriptor scaffoldDescriptorModel(File spec, SpecFormat format, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException {
        AMFAPIModel apiModel = new AMFAPIModel(spec, spec.getParent(), format, skipValidation);
        return DescriptorScaffolder.generateConnectorDescriptor(spec.toPath(), apiModel, descriptorMode);
    }

    public static void writeToYaml(ConnectorDescriptor connectorDescriptor, Path outputDir) throws IOException {
        DescriptorWriter descriptorWriter = new DescriptorWriter();
        String yaml = descriptorWriter.write(connectorDescriptor);
        FileUtils.writeStringToFile((File)outputDir.resolve(DESCRIPTOR_FILE_NAME).toFile(), (String)yaml, (Charset)StandardCharsets.UTF_8);
    }

    private static ConnectorDescriptor generateConnectorDescriptor(Path specPath, APIModel apiModel, DescriptorMode descriptorMode) {
        return new ConnectorDescriptor(descriptorMode.isGenerateApiSpec() ? DescriptorScaffolder.generateAPISpec(specPath) : null, descriptorMode.isGenerateApiName() ? DescriptorScaffolder.generateApiName(apiModel) : null, descriptorMode.isGenerateDescription() ? apiModel.getDescription() : null, descriptorMode.isGenerateConnectorGav() ? DescriptorScaffolder.generateConnectorGav(apiModel) : null, descriptorMode.isGenerateBaseUri() ? DescriptorScaffolder.generateBaseUri(apiModel) : null, descriptorMode.isGenerateEndpoints() ? DescriptorScaffolder.generateEndpoints(apiModel) : Collections.EMPTY_LIST, descriptorMode.isGeneratePaginations() ? DescriptorScaffolder.generatePaginations() : Collections.EMPTY_LIST, descriptorMode.isGenerateSecurity() ? DescriptorScaffolder.generateSecurity() : Collections.EMPTY_LIST, ConnectorCategory.SELECT.toString(), descriptorMode.isGenerateDefaultPackage() ? DescriptorScaffolder.generateDefaultPackage(apiModel) : null, descriptorMode.isGenerateExtensionXml() ? XmlUtils.getXmlName(DescriptorScaffolder.generateApiName(apiModel)) : null, null, null, null, null, null, null, null);
    }

    private static String generateDefaultPackage(APIModel apiModel) {
        return ConnectorPackage.buildBasePackage(DescriptorScaffolder.generateApiName(apiModel));
    }

    private static String generateApiName(APIModel apiModel) {
        String notApiName = apiModel.getApiName().replaceAll("[\\s]+(?i)api[\\s]+", "").replaceAll("^(?i)api[\\s]+", "").replaceAll("[\\s]+(?i)api$", "");
        return NamingUtil.makeNameFriendly(notApiName);
    }

    private static List<SecuritySchemeDescriptor> generateSecurity() {
        return Collections.emptyList();
    }

    private static List<EndPointDescriptor> generateEndpoints(APIModel apiModel) {
        return apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().map(x -> DescriptorScaffolder.generateEndpoint(x, apiModel)).collect(Collectors.toList());
    }

    private static EndPointDescriptor generateEndpoint(String path, APIModel apiModel) {
        return new EndPointDescriptor(path, DescriptorScaffolder.generateOperations(path, apiModel), false, null);
    }

    private static List<OperationDescriptor> generateOperations(String path, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path)).map(DescriptorScaffolder::generateOperation).collect(Collectors.toList());
    }

    private static OperationDescriptor generateOperation(APIOperationModel operationModel) {
        return new OperationDescriptor(operationModel.getHttpMethod().name().toLowerCase(), DescriptorScaffolder.generateOperationDisplayName(operationModel), operationModel.getDescription(), DescriptorScaffolder.generateDefaultInputMediaType(operationModel), DescriptorScaffolder.generateDefaultOutputMediaType(operationModel), DescriptorScaffolder.generateRequest(operationModel), false, null, null, DescriptorScaffolder.isBodylessResponse(operationModel), DescriptorScaffolder.isBodylessResponse(operationModel), null, null, null);
    }

    private static String generateOperationDisplayName(APIOperationModel operationModel) {
        return NamingUtil.isFriendlyName(operationModel.getName()) ? operationModel.getName() : NamingUtil.makeNameFriendly(operationModel.getName());
    }

    private static Boolean isBodylessResponse(APIOperationModel operationModel) {
        boolean methodRequiresBody;
        boolean bl = methodRequiresBody = operationModel.getHttpMethod().equals((Object)HTTPMethod.GET) || operationModel.getHttpMethod().equals((Object)HTTPMethod.POST) || operationModel.getHttpMethod().equals((Object)HTTPMethod.PATCH) || operationModel.getHttpMethod().equals((Object)HTTPMethod.OPTIONS);
        if (methodRequiresBody && operationModel.getOutputMetadataModel().isEmpty()) {
            return false;
        }
        boolean emptyBody = operationModel.getOutputMetadataModel().stream().allMatch(x -> x.getTypeDefinitionClass() == null || x.getTypeDefinitionClass().equals(EmptyTypeDefinition.class));
        if (methodRequiresBody && emptyBody) {
            return false;
        }
        return null;
    }

    private static String generateDefaultInputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getInputMetadataModel().isEmpty() && operationModel.getInputMetadataModel().get(0).getMediaType() != null) {
            return operationModel.getInputMetadataModel().get(0).getMediaType().toString();
        }
        return null;
    }

    private static String generateDefaultOutputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getOutputMetadataModel().isEmpty() && operationModel.getOutputMetadataModel().get(0).getMediaType() != null) {
            return operationModel.getOutputMetadataModel().get(0).getMediaType().toString();
        }
        return null;
    }

    private static RequestDescriptor generateRequest(APIOperationModel operationModel) {
        return new RequestDescriptor(DescriptorScaffolder.generateParameters(operationModel.getHeadersModel()), DescriptorScaffolder.generateParameters(operationModel.getQueryParamsModel()), DescriptorScaffolder.generateParameters(operationModel.getUriParamsModel()), new LinkedList<PartDescriptor>());
    }

    private static List<ParameterDescriptor> generateParameters(List<APIParameterModel> parametersModel) {
        return parametersModel.stream().map(DescriptorScaffolder::generateParameter).collect(Collectors.toList());
    }

    private static ParameterDescriptor generateParameter(APIParameterModel parameterModel) {
        return new ParameterDescriptor(DescriptorScaffolder.generateParameterDisplayName(parameterModel), parameterModel.getExternalName(), parameterModel.getDescription(), false, null);
    }

    private static String generateParameterDisplayName(APIParameterModel parameterModel) {
        return NamingUtil.isFriendlyName(parameterModel.getDisplayName()) ? parameterModel.getDisplayName() : NamingUtil.makeNameFriendly(parameterModel.getDisplayName());
    }

    private static List<PaginationDeclarationDescriptor> generatePaginations() {
        return Collections.emptyList();
    }

    private static BaseUriDescriptor generateBaseUri(APIModel apiModel) {
        return new BaseUriDescriptor(apiModel.getBaseUri().getUri(), apiModel.getBaseUri().getType().getName(), Collections.emptyList());
    }

    private static MavenGavDescriptor generateConnectorGav(APIModel apiModel) {
        return new MavenGavDescriptor(DEFAULT_MVN_GROUP_ID, XmlUtils.getXmlName(apiModel.getApiName()), DEFAULT_MVN_VERSION);
    }

    private static APISpecDescriptor generateAPISpec(Path specPath) {
        return new APIUrlDescriptor(specPath.toString());
    }
}

