/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.api.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.internal.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.util.AMFWrapper;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser;
import java.io.File;
import java.nio.file.Path;

public class RestSdk {
    private RestSdk() {
    }

    public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, String rootDir, RestSdkRunConfiguration runConfiguration) throws ModelGenerationException {
        AMFWrapper.initialize();
        ValidationEngine validationEngine = new ValidationEngine();
        DescriptorParser descriptorParser = new DescriptorParser();
        ConnectorDescriptor connectorDescriptor = descriptorParser.parseConnectorDescriptor(descriptor);
        APIModel apiModel = ApiParser.parseModel(spec, format, rootDir, runConfiguration.skipValidations());
        boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);
        try {
            ConnectorModelBuilder connectorModelBuilder = new ConnectorModelBuilder();
            ConnectorModel connectorModel = connectorModelBuilder.buildConnectorModel(apiModel, connectorDescriptor);
            if (preValidationSuccess && validationEngine.postValidate(connectorModel)) {
                return connectorModel;
            }
            throw new ModelGenerationException("There are validation errors");
        }
        catch (Exception e) {
            if (preValidationSuccess) {
                throw e;
            }
            throw new ModelGenerationException("There are validation errors");
        }
    }

    public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir, Path descriptorPath, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        TemplateEntity.getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath, runConfiguration).applyTemplates();
    }
}

