/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.NotSupportedScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.PassThroughScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionValidationConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.UnsecuredScheme;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;

public class ConnectorSecuritySchemeBuilder {
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorSecuritySchemeBuilder(ConnectorTypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        this.parameterBuilder = new ConnectorParameterBuilder(connectorTypeDefinitionBuilder);
    }

    public List<ConnectorSecurityScheme> buildSecuritySchemes(List<APISecuritySchemeModel> apiSecuritySchemeModels, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        List<SecuritySchemeDescriptor> securityDescriptors = connectorDescriptor.getSecurity();
        LinkedList<ConnectorSecurityScheme> apiSecuritySchemes = new LinkedList<ConnectorSecurityScheme>();
        if (!apiSecuritySchemeModels.isEmpty()) {
            for (APISecuritySchemeModel securitySchemeModel : apiSecuritySchemeModels) {
                ConnectorSecurityScheme apiSecurityScheme = this.buildSecurityScheme(securitySchemeModel, this.getSecuritySchemeDescriptor(securityDescriptors, securitySchemeModel), connectorDescriptor);
                if (apiSecurityScheme == null || apiSecurityScheme instanceof NotSupportedScheme) continue;
                apiSecuritySchemes.add(apiSecurityScheme);
            }
        } else {
            apiSecuritySchemes.add(new UnsecuredScheme(this.buildTestConnectionConfig(connectorDescriptor.getTestConnection())));
        }
        return apiSecuritySchemes;
    }

    private TestConnectionConfig buildTestConnectionConfig(TestConnectionDescriptor testConnectionDescriptor) {
        if (testConnectionDescriptor == null) {
            return null;
        }
        return new TestConnectionConfig(testConnectionDescriptor.getPath(), testConnectionDescriptor.getMethod() == null ? null : HttpConstants.Method.valueOf((String)testConnectionDescriptor.getMethod().toUpperCase()), testConnectionDescriptor.getValidStatusCodes(), testConnectionDescriptor.getMediaType() == null ? null : MediaType.parse((String)testConnectionDescriptor.getMediaType()), testConnectionDescriptor.getResponseValidation().stream().map(this::buildTestConnectionValidationConfig).collect(Collectors.toList()));
    }

    private TestConnectionValidationConfig buildTestConnectionValidationConfig(TestConnectionResponseValidationDescriptor responseValidation) {
        if (responseValidation.getValidationExpression() == null || StringUtils.isBlank((CharSequence)responseValidation.getValidationExpression().getExpression())) {
            return null;
        }
        String errorExpression = responseValidation.getErrorTemplateExpression() != null ? responseValidation.getErrorTemplateExpression().getExpression() : null;
        return new TestConnectionValidationConfig(responseValidation.getValidationExpression().getExpression(), errorExpression);
    }

    private SecuritySchemeDescriptor getSecuritySchemeDescriptor(List<SecuritySchemeDescriptor> securities, APISecuritySchemeModel securitySchemeModel) {
        return securities.stream().filter(x -> x.getDisplayName().equalsIgnoreCase(securitySchemeModel.getName())).findFirst().orElse(null);
    }

    private ConnectorSecurityScheme buildSecurityScheme(APISecuritySchemeModel securitySchemeModel, SecuritySchemeDescriptor securitySchemeDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        TestConnectionDescriptor testConnectionDescriptor = securitySchemeDescriptor != null && securitySchemeDescriptor.getTestConnection() != null ? securitySchemeDescriptor.getTestConnection() : connectorDescriptor.getTestConnection();
        TestConnectionConfig testConnectionConfig = this.buildTestConnectionConfig(testConnectionDescriptor);
        if (securitySchemeDescriptor != null && securitySchemeDescriptor.isIgnored()) {
            return null;
        }
        Class<? extends ConnectorSecurityScheme> securitySchemeClass = securitySchemeModel.getSecuritySchemeClass();
        LinkedList<String> collisionNames = new LinkedList<String>();
        List<Parameter> customQueryParams = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomQueryParams(), securitySchemeDescriptor, collisionNames);
        collisionNames.addAll(customQueryParams.stream().map(Parameter::getInternalName).collect(Collectors.toList()));
        List<Parameter> customHeaders = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomHeaders(), securitySchemeDescriptor, collisionNames);
        ConnectorSecurityScheme.Builder builder = ConnectorSecurityScheme.builder(securitySchemeModel.getName(), customQueryParams, customHeaders, testConnectionConfig);
        if (securitySchemeClass.equals(BasicAuthScheme.class)) {
            return builder.buildBasicAuthScheme();
        }
        if (securitySchemeClass.equals(CustomAuthenticationScheme.class)) {
            return builder.buildCustomAuthenticationScheme();
        }
        if (securitySchemeClass.equals(DigestAuthenticationScheme.class)) {
            return builder.buildDigestAuthenticationSchemeScheme();
        }
        if (securitySchemeClass.equals(OAuth2AuthorizationCodeScheme.class)) {
            return builder.buildOAuth2AuthorizationCodeScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(OAuth2ClientCredentialsScheme.class)) {
            return builder.buildOAuth2ClientCredentialsScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(PassThroughScheme.class)) {
            return builder.buildPassThroughScheme();
        }
        return builder.buildUnsecuredScheme();
    }
}

