/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeSchemaBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ObjectTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.UnionTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.TypeSchemaPool;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class ConnectorTypeDefinitionBuilder {
    private final ConnectorTypeSchemaBuilder typeSchemaBuilder;
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorTypeDefinitionBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaBuilder = new ConnectorTypeSchemaBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this);
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        return this.buildTypeDefinition(apiTypeModel, partDescriptors, apiTypeModel.getMediaType());
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors, MediaType mediaType) throws ModelGenerationException {
        Class<? extends TypeDefinition> typeDefinitionClass;
        TypeDefinition.Builder typeDefinitionBuilder = TypeDefinition.builder(mediaType, this.typeSchemaBuilder.buildTypeSchema(apiTypeModel.getAPITypeSchemaModel()), apiTypeModel.getEnumValues(), apiTypeModel.getExample());
        if (RestSdkUtils.isNotBlank((String)apiTypeModel.getDisplayName())) {
            typeDefinitionBuilder.withDisplayName(apiTypeModel.getDisplayName());
        }
        if (RestSdkUtils.isNotBlank((String)apiTypeModel.getDescription())) {
            typeDefinitionBuilder.withDescription(apiTypeModel.getDescription());
        }
        if ((typeDefinitionClass = apiTypeModel.getTypeDefinitionClass()) == null) {
            return null;
        }
        if (typeDefinitionClass.equals(EmptyTypeDefinition.class)) {
            return typeDefinitionBuilder.buildEmptyTypeDefinition();
        }
        if (typeDefinitionClass.equals(PrimitiveTypeDefinition.class)) {
            return typeDefinitionBuilder.buildPrimitiveTypeDefinition(this.buildPrimitiveType(apiTypeModel.getPrimitiveTypeModel()));
        }
        if (typeDefinitionClass.equals(ObjectTypeDefinition.class)) {
            return typeDefinitionBuilder.buildObjectTypeDefinition();
        }
        if (typeDefinitionClass.equals(ArrayTypeDefinition.class)) {
            MediaType innerMediaType = apiTypeModel.getInnerType().getMediaType() != null ? apiTypeModel.getInnerType().getMediaType() : mediaType;
            return typeDefinitionBuilder.buildArrayType(this.buildTypeDefinition(apiTypeModel.getInnerType(), null, innerMediaType));
        }
        if (typeDefinitionClass.equals(UnionTypeDefinition.class)) {
            ArrayList<TypeDefinition> unionTypes = new ArrayList<TypeDefinition>();
            for (APITypeModel typeModel : apiTypeModel.getUnionTypes()) {
                TypeDefinition typeDefinition = this.buildTypeDefinition(typeModel, null, mediaType);
                unionTypes.add(typeDefinition);
            }
            return typeDefinitionBuilder.buildUnionTypeDefinition(unionTypes);
        }
        if (typeDefinitionClass.equals(MultipartTypeDefinition.class)) {
            ArrayList<PartParameter> parts = new ArrayList<PartParameter>();
            for (APIParameterModel apiParameterModel : apiTypeModel.getParts()) {
                PartDescriptor partDescriptor = null;
                if (partDescriptors != null) {
                    partDescriptor = partDescriptors.stream().filter(x -> x.getPartName().equals(apiParameterModel.getExternalName())).findFirst().orElse(null);
                }
                PartParameter partParameter = this.parameterBuilder.buildPartParameter(apiParameterModel, partDescriptor);
                parts.add(partParameter);
            }
            return typeDefinitionBuilder.buildMultipartTypeDefinition(parts);
        }
        return null;
    }

    public TypeDefinition buildTypeDefinition(String rawSchema, MediaType mediaType) throws ModelGenerationException {
        TypeSchema typeSchema = this.typeSchemaBuilder.buildTypeSchema(rawSchema);
        if (mediaType == null) {
            mediaType = typeSchema instanceof XmlTypeSchema ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
        return TypeDefinition.builder(mediaType, typeSchema, null, null).buildObjectTypeDefinition();
    }

    private PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(APIPrimitiveTypeModel primitiveTypeModel) {
        return primitiveTypeModel.getPrimitiveType();
    }
}

