/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import org.apache.commons.lang.StringUtils;

public class ConnectorTypeSchemaBuilder {
    private final TypeSchemaPool typeSchemaPool;

    public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaPool = typeSchemaPool;
    }

    public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) {
        if (apiTypeSchemaModel == null) {
            return null;
        }
        return this.getUniqueTypeSchema(apiTypeSchemaModel.getTypeSchema());
    }

    public TypeSchema buildTypeSchema(String rawSchema) {
        if (XmlUtils.isXmlSchema(rawSchema)) {
            return this.getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
        }
        return this.getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }

    private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
        if (typeSchema != null && StringUtils.isNotBlank((String)typeSchema.getRawSchema())) {
            return this.typeSchemaPool.getUniqueTypeSchema(typeSchema);
        }
        return typeSchema;
    }
}

