/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import org.apache.commons.lang3.StringUtils;

public enum DataTypeDescriptor {
    STRING("string"),
    INTEGER("integer"),
    NUMBER("number"),
    ZONED_DATE_TIME("zonedDateTime"),
    LOCAL_DATE_TIME("localDateTime"),
    BOOLEAN("boolean");

    private final String name;

    private DataTypeDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DataTypeDescriptor forName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.equalsIgnoreCase(STRING.getName())) {
            return STRING;
        }
        if (name.equalsIgnoreCase(INTEGER.getName())) {
            return INTEGER;
        }
        if (name.equalsIgnoreCase(NUMBER.getName())) {
            return NUMBER;
        }
        if (name.equalsIgnoreCase(ZONED_DATE_TIME.getName())) {
            return ZONED_DATE_TIME;
        }
        if (name.equalsIgnoreCase(LOCAL_DATE_TIME.getName())) {
            return LOCAL_DATE_TIME;
        }
        if (name.equalsIgnoreCase(BOOLEAN.getName())) {
            return BOOLEAN;
        }
        throw new IllegalArgumentException("Data Type not supported: '" + name + "'");
    }
}

